<?php
class IdeabizOperations
{
    public $CONNECT;
    public $IDEABIZ_USERNAME;
    public $IDEABIZ_PASSWORD;
    public $IDEABIZ_CONSUMER_KEY;
    public $IDEABIZ_CONSUMER_SECRET;

    function __construct($CONNECT, $IDEABIZ_USERNAME, $IDEABIZ_PASSWORD, $IDEABIZ_CONSUMER_KEY, $IDEABIZ_CONSUMER_SECRET)
    {
        $this->CONNECT = $CONNECT;
        $this->IDEABIZ_USERNAME = $IDEABIZ_USERNAME;
        $this->IDEABIZ_PASSWORD = $IDEABIZ_PASSWORD;
        $this->IDEABIZ_CONSUMER_KEY = $IDEABIZ_CONSUMER_KEY;
        $this->IDEABIZ_CONSUMER_SECRET = $IDEABIZ_CONSUMER_SECRET;
    }

    function get_ideabiz_access_token()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ideabiz.lk/apicall/token?grant_type=password&username=' . $this->IDEABIZ_USERNAME . '&password=' . $this->IDEABIZ_PASSWORD . '&scope=PRODUCTION',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic ' . base64_encode($this->IDEABIZ_CONSUMER_KEY . ":" . $this->IDEABIZ_CONSUMER_SECRET)
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $jsonResp = json_decode($response, true);
        return $jsonResp['access_token'];
    }

    function getNormalOtp($mobileNumber, $hash, $device, $os, $appCode)
    {
        $data = array(
            'method' => "Web",
            'msisdn' => $mobileNumber
        );
        $res = $this->sendRequestAuth("https://ideabiz.lk/apicall/pin/subscription/v1/subscribe", $data, $this->get_ideabiz_access_token());
        return $res;
    }

    function verifyOtpCode($serverRef, $pin)
    {
        $data = array(
            'pin' => $pin,
            'serverRef' => $serverRef
        );
        $res = $this->sendRequestAuth("https://ideabiz.lk/apicall/pin/subscription/v1/submitPin", $data, $this->get_ideabiz_access_token());
        if (isset($res["data"])) {
            $status = $res["data"]["status"];
            $msisdn = $res["data"]["msisdn"];
            if ($status == "SUBSCRIBED") {
                return array(
                    "MESSAGE" => $this->completeSubscription($msisdn, "1")
                );
            } else {
                return array(
                    "MESSAGE" => "Unable to process request at this moment"
                );
            }
        }
        return array(
            "MESSAGE" => "Unable to process request"
        );
    }

    function completeSubscription($address, $category)
    {
        $findQuery = mysqli_query($this->CONNECT, "SELECT id FROM users WHERE subNumber='$address';");
        if ($findQuery) {
            $userRows = mysqli_num_rows($findQuery);
            if ($userRows == 0) {
                $query = mysqli_query($this->CONNECT, "INSERT INTO `users` (`id`, `subNumber`, `fullName`, `category`, `platform`, `signupDate`) VALUES (NULL, '$address', 'User', '$category', 'ideabiz', now());");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            } else {
                $query = mysqli_query($this->CONNECT, "UPDATE `users` SET subscriberState='pending', category='$category' WHERE subNumber='$address';");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            }
        } else {
            return ("An error has occured, please try again.");
        }
    }

    function completeOtpSubscription($address, $category, $name, $appRef, $mobile, $device)
    {
        $findQuery = mysqli_query($this->CONNECT, "SELECT id FROM users WHERE subNumber='$address';");
        if ($findQuery) {
            $userRows = mysqli_num_rows($findQuery);
            if ($userRows == 0) {
                $query = mysqli_query($this->CONNECT, "INSERT INTO `users` (`id`, `subNumber`, `fullName`, `category`, `platform`, `signupDate`, `referal`, `mobile`, `device`) VALUES (NULL, '$address', '$name', '$category', 'ideabiz', now(), '$appRef', '$mobile', '$device');");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            } else {
                $query = mysqli_query($this->CONNECT, "UPDATE `users` SET subscriberState='pending', category='$category', fullName='$name', device='$device' WHERE subNumber='$address';");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            }
        } else {
            return ("An error has occured, please try again.");
        }
    }

    function sendRequestAuth($endPoint, $data, $token)
    {
        $payload = json_encode($data);
        $ch = curl_init($endPoint);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type:application/json',
            'Authorization:Bearer ' . $token
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        error_log($result);

        return json_decode($result, true);
    }
}
