<?php

include('../connection.php');

if ($_SERVER['SERVER_ADDR'] != $_SERVER['REMOTE_ADDR']) {
    $this->output->set_status_header(400, 'No Remote Access Allowed');
    exit; //just for good measure
}

require 'vendor/autoload.php';

use SqsSimple\SqsMessenger;

$AwsConfig = [
    'AWS_KEY'           => $AWS_KEY,
    'AWS_SECRET_KEY'    => $AWS_SECRET,
    'AWS_REGION'        => $AWS_REGION,
    'API_VERSION'       => 'latest',
];

$messenger = new SqsMessenger($AwsConfig);

function send_to_sqs($payload, $queueUrl)
{
    global $messenger;
    $messenger->publish($queueUrl, json_encode($payload));
}

function get_messages_list()
{
    global $connect;
    $messages = array();

    //Fetch messages
    $query = mysqli_query($connect, "SELECT u.subNumber, u.platform, (SELECT m.message FROM messages AS m WHERE m.category = u.category AND m.hasSent = '0' ORDER BY id ASC LIMIT 1) AS message FROM users as u WHERE u.subscriberState != 'pending' AND u.subscriberState != 'unsubscribed' HAVING message IS NOT NULL;");
    while ($dataRow = mysqli_fetch_array($query)) {
        array_push($messages, $dataRow);
    }

    //Update sent status on database
    $getMessageIdQuery = mysqli_query($connect, "SELECT DISTINCT(SELECT DISTINCT(m.id) FROM messages AS m WHERE m.category = u.category AND m.hasSent = '0' ORDER BY id ASC LIMIT 1) AS messageId FROM users as u WHERE u.subscriberState != 'pending' AND u.subscriberState != 'unsubscribed' HAVING messageId IS NOT NULL;");
    while ($getMessageIdData = mysqli_fetch_array($getMessageIdQuery)) {
        $messageId = $getMessageIdData['messageId'];
        mysqli_query($connect, "UPDATE messages SET hasSent='1' WHERE id='$messageId';");
    }

    return $messages;
}

function process_messages()
{
    global $IDEAMART_APP_ID;
    global $MSPACE_APP_ID;
    global $IDEAMART_APP_PASSWORD;
    global $MSPACE_APP_PASSWORD;
    global $MESSAGE_QUEUE_URL;

    $messages = get_messages_list();
    foreach ($messages as $message) {
        $payload = array(
            "PLATFORM"  =>  $message['platform'],
            "APP_ID"    =>  $message['platform'] == "ideamart" ? $IDEAMART_APP_ID : $MSPACE_APP_ID,
            "APP_PASSWORD"  =>  $message['platform'] == "ideamart" ? $IDEAMART_APP_PASSWORD : $MSPACE_APP_PASSWORD,
            "MESSAGE"   => $message['message'],
            "SUB_NUMBER"    => $message['subNumber'],
        );
        send_to_sqs($payload, $MESSAGE_QUEUE_URL);
    }
    echo (count($messages) . " messages added to queue.");
}

process_messages();
