<?php

include('../connection.php');

if ($_SERVER['SERVER_ADDR'] != $_SERVER['REMOTE_ADDR']) {
    $this->output->set_status_header(400, 'No Remote Access Allowed');
    exit; //just for good measure
}

require 'vendor/autoload.php';

use SqsSimple\SqsMessenger;

$AwsConfig = [
    'AWS_KEY'           => $AWS_KEY,
    'AWS_SECRET_KEY'    => $AWS_SECRET,
    'AWS_REGION'        => $AWS_REGION,
    'API_VERSION'       => 'latest',
];

$messenger = new SqsMessenger($AwsConfig);

function send_to_sqs($payload, $queueUrl)
{
    global $messenger;
    $messenger->publish($queueUrl, json_encode($payload));
}

function get_user_base()
{
    global $connect;
    $users = array();

    $query = mysqli_query($connect, "SELECT subNumber FROM users WHERE platform='ideabiz' AND subscriberState='subscribed';");
    while ($dataRow = mysqli_fetch_array($query)) {
        array_push($users, $dataRow["subNumber"]);
    }

    return $users;
}

function process_charging()
{
    global $CHARGING_QUEUE_URL;
    $users = get_user_base();
    foreach ($users as $user) {
        send_to_sqs($user, $CHARGING_QUEUE_URL);
    }
    echo (count($users) . " users were queued for charging.");
}

process_charging();
