<?php

include("../connection.php");

if ($_SERVER['SERVER_ADDR'] != $_SERVER['REMOTE_ADDR']) {
    $this->output->set_status_header(400, 'No Remote Access Allowed');
    exit;
}

//Fetch pending message
$messageQuery = mysqli_query($connect, "SELECT message, id FROM messages WHERE hasSent='0' ORDER BY id ASC LIMIT 1;");
$messageData = mysqli_fetch_array($messageQuery);

if (isset($messageData[0])) {

    $messageBody = $messageData[0];
    $messageId = $messageData[1];

    if ($ENABLED_SERVICES["MSPACE"]) {
        send_message_mspace($messageBody);
        echo "Mspace messages sent: " . $messageBody;
    }

    if ($ENABLED_SERVICES["IDEAMART"]) {
        send_message_ideamart($messageBody);
        echo "Ideamart messages sent: " . $messageBody;
    }

    if ($ENABLED_SERVICES["IDEABIZ"]) {
        send_message_ideabiz($messageBody);
        echo "Ideabiz messages sent: " . $messageBody;
    }

    mysqli_query($connect, "UPDATE messages SET hasSent='1' WHERE id='$messageId';");
} else {
    //Change all messages to not sent
    mysqli_query($connect, "UPDATE messages SET hasSent='0';");

    //Fetch pending message
    $messageQuery = mysqli_query($connect, "SELECT message, id FROM messages WHERE hasSent='0' ORDER BY id ASC LIMIT 1;");

    if (isset($messageData[0])) {

        $messageBody = $messageData[0];
        $messageId = $messageData[1];

        if ($ENABLED_SERVICES["MSPACE"]) {
            send_message_mspace($messageBody);
            echo "Mspace messages sent: " . $messageBody;
        }

        if ($ENABLED_SERVICES["IDEAMART"]) {
            send_message_ideamart($messageBody);
            echo "Ideamart messages sent: " . $messageBody;
        }

        if ($ENABLED_SERVICES["IDEABIZ"]) {
            send_message_ideabiz($messageBody);
            echo "Ideabiz messages sent: " . $messageBody;
        }

        mysqli_query($connect, "UPDATE messages SET hasSent='1' WHERE id='$messageId';");
    }
}

function send_message_ideamart($message)
{
    global $IDEAMART_APP_ID, $IDEAMART_APP_PASSWORD, $IDEAMART_ENDPOINT;
    $data = array(
        'applicationId' => $IDEAMART_APP_ID,
        'password' => $IDEAMART_APP_PASSWORD,
        'destinationAddresses' => ["tel:all"],
        'message' =>   $message
    );
    return sendRequest($IDEAMART_ENDPOINT . "/sms/send", $data);
}

function send_message_mspace($message)
{
    global $MSPACE_APP_ID, $MSPACE_APP_PASSWORD, $MSPACE_ENDPOINT;
    $data = array(
        'applicationId' => $MSPACE_APP_ID,
        'password' => $MSPACE_APP_PASSWORD,
        'destinationAddresses' => ["tel:all"],
        'message' =>   $message
    );
    return sendRequest($MSPACE_ENDPOINT . "/sms/send", $data);
}

//Get Ideabiz access token
function get_ideabiz_access_token()
{
    global $IDEABIZ_CONSUMER_KEY;
    global $IDEABIZ_CONSUMER_SECRET;
    global $IDEABIZ_USERNAME;
    global $IDEABIZ_PASSWORD;

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ideabiz.lk/apicall/token?grant_type=password&username=' . $IDEABIZ_USERNAME . '&password=' . $IDEABIZ_PASSWORD . '&scope=PRODUCTION',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Basic ' . base64_encode($IDEABIZ_CONSUMER_KEY . ":" . $IDEABIZ_CONSUMER_SECRET)
        ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $jsonResp = json_decode($response, true);
    return $jsonResp['access_token'];
}

function send_message_ideabiz($message)
{
    global $IDEABIZ_ENDPOINT,
        $IDEABIZ_SENDER_ADDR, $IDEABIZ_CLIENT_CORR, $IDEABIZ_SENDER_NAME, $IDEABIZ_SENDER_PORT,
        $connect;

    //query for ideabiz subs list
    $ideabizSubQuery = mysqli_query($connect, "SELECT subNumber FROM users WHERE platform='ideabiz' AND subscriberState='subscribed';");
    $ideaBizArray = array();
    while ($ideabizSubData = mysqli_fetch_assoc($ideabizSubQuery)) {
        array_push($ideaBizArray, $ideabizSubData['subNumber']);
    }

    $data = [
        "outboundSMSMessageRequest" => [
            "address" => $ideaBizArray,
            "senderAddress" => $IDEABIZ_SENDER_ADDR,
            "outboundSMSTextMessage" => [
                "message" => $message
            ],
            "clientCorrelator" => $IDEABIZ_CLIENT_CORR,
            "senderName" => $IDEABIZ_SENDER_NAME
        ]
    ];

    $url = $IDEABIZ_ENDPOINT . "/smsmessaging/v3/outbound/" . $IDEABIZ_SENDER_PORT . "/requests";
    $token = get_ideabiz_access_token();

    $resp = sendRequestAuth($url, $data, $token);

    return $resp;
}

//Send un-authenticated request
function sendRequest($endPoint, $data)
{
    $payload = json_encode($data);
    $ch = curl_init($endPoint);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    error_log($result);
    return json_decode($result, true);
}

//Send authenticated request
function sendRequestAuth($endPoint, $data, $token)
{
    $payload = json_encode($data);
    $ch = curl_init($endPoint);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type:application/json',
        'Authorization:Bearer ' . $token
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    print_r($result);
    curl_close($ch);
    error_log($result);
    return json_decode($result, true);
}
