<?php
include("../connection.php");
include("../functions.php");
include("../ideabizFunctions.php");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title><?php echo $APP_DESC; ?></title>
    <!-- MDB icon -->
    <!-- <link rel="icon" href="img/mdb-favicon.ico" type="image/x-icon" /> -->
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <!-- Google Fonts Roboto -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" />
    <!-- MDB -->
    <link rel="stylesheet" href="css/mdb.min.css" />

    <link rel="stylesheet" href="css/custom.css" />

</head>

<?php
$errors = array();

//Set app reference
if (isset($_GET['appRef'])) {
    $appRef = $_GET['appRef'];
} else {
    $appRef = '1';
}

if (isset($_POST["getOtp"])) {
    $mobileInput = $_POST["mobileInput"];
    $nameInput = "User";
    if (!empty($mobileInput)) {
        //Detect platform 
        $platform = detectNumber($mobileInput);
        if ($platform["STATUS"] == "success") {
            if ($platform["MESSAGE"] == "ideamart") {
                $telco = new TelcoOperations($IDEAMART_ENDPOINT, $IDEAMART_APP_ID, $IDEAMART_APP_PASSWORD, $connect, "ideamart");
            } else if ($platform["MESSAGE"] == "ideabiz") {
                $telco = new IdeabizOperations($connect, $IDEABIZ_USERNAME, $IDEABIZ_PASSWORD, $IDEABIZ_CONSUMER_KEY, $IDEABIZ_CONSUMER_SECRET);
            } else {
                $telco = new TelcoOperations($MSPACE_ENDPOINT, $MSPACE_APP_ID, $MSPACE_APP_PASSWORD, $connect, "mspace");
            }

            //Get category
            $category = isset($_POST["category"]) ? $_POST["category"] : "1";

            //Send OTP Code
            $otpResp = $telco->getNormalOtp($mobileInput, $APP_HASH, $DEVICE_DEFAULT, $OS_DEFAULT, $APP_CODE);
            if (isset($otpResp) && ($otpResp["statusCode"] == "S1000" || $otpResp["statusCode"] == "SUCCESS")) {
                $refNumber = $platform["MESSAGE"] == "ideabiz" ? $otpResp["data"]["serverRef"] : $otpResp["referenceNo"];
                header("Location: verify.php?otpref=" . $refNumber . "&appRef=" . $appRef . "&name=" . $nameInput . "&platform=" . $platform["MESSAGE"] . "&mobile=" . $mobileInput . "&category=" . $category);
                exit();
            } else if (isset($otpResp["statusDetail"])) {
                array_push($errors, $otpResp["statusDetail"]);
            } else if (isset($otpResp["message"])) {
                array_push($errors, $otpResp["message"]);
            } else {
                array_push($errors, "An error has occured while sending OTP code! Please try again later.");
            }
        } else {
            array_push($errors, $platform["MESSAGE"]);
        }
    } else {
        array_push($errors, "Mobile number is required!");
    }
}

function detectNumber($number)
{
    global $ENABLED_SERVICES;

    if (strlen($number) == 10) {
        if (preg_match('/071|070/m', $number)) {
            if ($ENABLED_SERVICES['MSPACE'] == true) {
                return array(
                    "STATUS" => "success",
                    "MESSAGE" => "mspace"
                );
            } else {
                return array(
                    "STATUS" => "error",
                    "MESSAGE" => "Mobitel numbers are not supported at the moment!"
                );
            }
        } else {
            if ($ENABLED_SERVICES['IDEABIZ'] == true) {
                return array(
                    "STATUS" => "success",
                    "MESSAGE" => "ideabiz"
                );
            } else {
                return array(
                    "STATUS" => "success",
                    "MESSAGE" => "ideamart"
                );
            }
        }
    } else {
        return array(
            "STATUS" => "error",
            "MESSAGE" => "The mobile number has to contain 10 characters only"
        );
    }
}

?>

<body>
    <div class="container">
        <div class="d-flex justify-content-center align-items-center" style="height: 100vh">
            <div class="text-center">
                <div class="card">
                    <div class="row">
                        <div class="col-md">
                            <?php include("slider.php"); ?>
                        </div>
                        <div class="col-md maincontent" style="display: table;">
                            <div class="card-body" style="display: table-cell;vertical-align: middle;">
                                <img src="img/custom/logo-light.png" width="100" style="margin-bottom: 31px;" />
                                <h5 class="card-title display-8">තොරතුරු ලබාගැනීම සඳහා</h5>
                                <h5 class="card-title display-6">ලියාපදිංචි වන්න</h5>
                                <form method="post" action="#">
                                    <!-- Password input -->
                                    <div class="form-outline mb-4">
                                        <input type="text" id="mobileInput" name="mobileInput" class="form-control" style="margin-top: 1.5rem!important;" />
                                        <label class="form-label" for="mobileInput">Mobile Number</label>
                                    </div>

                                    <!-- Password input -->
                                    <?php
                                    $categoriesQ = mysqli_query($connect, "SELECT * FROM categories");
                                    $categoriesR = mysqli_num_rows($categoriesQ);
                                    if ($categoriesR > 1) {
                                    ?>
                                        <div class="form-outline mb-4">
                                            <label class="form-label select-label">Please choose the category: </label>
                                            <select class="select" style="padding: 5px;" name="category">
                                                <?php
                                                while ($cat = mysqli_fetch_array($categoriesQ)) {
                                                    echo '<option value="' . $cat['id'] . '">' . $cat['category'] . '</option>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    <?php } ?>

                                    <!-- Submit button -->
                                    <button type="submit" class="btn btn-primary btn-block mb-4" name="getOtp" style="background: #003366;color:#ff9900;">Register</button>
                                </form>
                                <?php
                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<p class="note note-danger"><strong>Error:</strong> ' . $error . '</p>';
                                    }
                                }
                                ?>
                                <p style="font-size: 11px;margin:0;"><?php echo isset($CHARGING_TEXT) ? "**" . $CHARGING_TEXT : "" ?></p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- MDB -->
    <script type="text/javascript" src="js/mdb.min.js"></script>
    <!-- Custom scripts -->
    <script type="text/javascript"></script>
</body>

</html>