<?php
include("includes/header.php");
if ($_SESSION["isAnalyticsAdmin"] == 1) {
   header("Location: analytics.php");
   exit();
}

//Apply search filters
if (isset($_POST['applyFilter'])) {
   $startDate = $_POST["startDate"];
   $endDate = $_POST["endDate"];

   if (!empty($startDate) && !empty($endDate)) {
      echo $startDate;
   }
}
?>

<h3>Filter by date</h3>

<div class="row">
   <div class="col-md-12">
      <form action="#" method="post">
         Start date:
         <input type="date" name="startDate" value="<?php echo isset($startDate) ? $startDate : "" ?>" />

         End date:
         <input type="date" name="endDate" value="<?php echo isset($endDate) ? $endDate : "" ?>" />

         <input type="submit" class="btn btn-primary" value="Filter" name="applyFilter" />
      </form>
   </div>
</div>

<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-header card-header-primary">
            <div style="display:inline-block;">
               <h4 class="card-title ">Referrals</h4>
               <p class="card-category">All referral related statistics</p>
            </div>
            <a href="newref.php" class="btn btn-primary pull-right">New</a>
         </div>
         <div class="card-body">
            <div class="table-responsive">
               <table class="table">
                  <thead class=" text-primary">
                     <th>ID</th>
                     <th>Referee Name</th>
                     <th>Code</th>
                     <th>Total Users</th>
                     <th>Active Users</th>
                     <th>Unregistered</th>
                     <th>Actions</th>
                  </thead>
                  <tbody>
                     <?php
                     $query = mysqli_query($connect, "SELECT * FROM referrals");
                     while ($data = mysqli_fetch_assoc($query)) {
                        $refCode = $data["code"];

                        if (!empty($startDate) && !empty($endDate)) {
                           $totQuery = mysqli_query($connect, "SELECT count(*) AS totalRegistered FROM users WHERE referal='$refCode' AND signupDate BETWEEN '$startDate' AND '$endDate';");
                        } else {
                           $totQuery = mysqli_query($connect, "SELECT count(*) AS totalRegistered FROM users WHERE referal='$refCode';");
                        }
                        $totRow = mysqli_fetch_assoc($totQuery);
                        $totalCount = $totRow["totalRegistered"];

                        if (!empty($startDate) && !empty($endDate)) {
                           $totActiveQuery = mysqli_query($connect, "SELECT count(*) AS totalActive FROM users WHERE subscriberState='subscribed' AND referal='$refCode' AND chargedDate BETWEEN '$startDate' AND '$endDate';");
                        } else {
                           $totActiveQuery = mysqli_query($connect, "SELECT count(*) AS totalActive FROM users WHERE subscriberState='subscribed' AND referal='$refCode';");
                        }
                        $totActiveRow = mysqli_fetch_assoc($totActiveQuery);
                        $totalActiveCount = $totActiveRow["totalActive"];

                        if (!empty($startDate) && !empty($endDate)) {
                           $totTodayUnQuery = mysqli_query($connect, "SELECT count(*) AS totalUnToday FROM users WHERE unsubscribeDate BETWEEN '$startDate' AND '$endDate' AND subscriberState='unsubscribed' AND referal='$refCode';");
                        } else {
                           $totTodayUnQuery = mysqli_query($connect, "SELECT count(*) AS totalUnToday FROM users WHERE subscriberState='unsubscribed' AND referal='$refCode';");
                        }
                        $totTodayUnRow = mysqli_fetch_assoc($totTodayUnQuery);
                        $totalUnregistered = $totTodayUnRow["totalUnToday"];
                     ?>
                        <tr>
                           <td><?php echo $data["id"] ?></td>
                           <td class="text-primary"><?php echo $data["name"] ?></td>
                           <td><?php echo $data["code"] ?></td>
                           <td><?php echo $totalCount ?></td>
                           <td><?php echo $totalActiveCount ?></td>
                           <td><?php echo $totalUnregistered ?></td>
                           <td><a href="editref.php?id=<?php echo $data["id"] ?>" class="btn btn-primary">Edit</a> <a href="deleteref.php?id=<?php echo $data["id"] ?>" class="btn btn-primary">Delete</a></td>
                        </tr>
                     <?php
                     }
                     ?>
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>
</div>

<?php include("includes/footer.php"); ?>