<?php
include("includes/header.php");

if($_SESSION["isAnalyticsAdmin"] == 1){
    header("Location: analytics.php");
    exit();
 }

$errors = array();

if(isset($_POST["addRef"])){
    $name = $_POST["name"];
    $email = $_POST["email"];
    $code = $_POST["code"];

    if(empty($name)){
        array_push($errors, "Referee name is required");
    }
    
    if(empty($email)){
        array_push($errors, "Email is required");
    }

    if(empty($code)){
        array_push($errors, "Code is required");
    }

    if(empty($errors)){
        $name = mysqli_real_escape_string($connect, $name);
        $email = mysqli_real_escape_string($connect, $email);
        $code = mysqli_real_escape_string($connect, $code);
        $query = mysqli_query($connect, "INSERT INTO `referrals` (`id`, `name`, `email`, `code`) VALUES (NULL, '$name', '$email', '$code');");
        if($query){
            array_push($errors, "Successfully added new referee");
        } else {
            array_push($errors, "An error has occured");
        }
    }
}

?>

<div class="row">
   <div class="col-md-8">
      <div class="card">
         <div class="card-header card-header-primary">
            <h4 class="card-title">New Referee</h4>
            <p class="card-category">Add new referee to database</p>
         </div>
         <div class="card-body">
            <form method="post" action="#">
               <div class="row">
                  <div class="col-md-12">
                     <div class="form-group">
                        <label class="bmd-label-floating">Name</label>
                        <input type="text" name="name" class="form-control"/>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-12">
                     <div class="form-group">
                        <label class="bmd-label-floating">Email</label>
                        <input type="email" name="email" class="form-control"/>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-12">
                     <div class="form-group">
                        <label class="bmd-label-floating">Code</label>
                        <input type="text" name="code" class="form-control" value="<?php echo md5(time()."%4554354".time()); ?>"/>
                     </div>
                  </div>
               </div>
               <input type="submit" class="btn btn-primary pull-right" value="Add Referee" name="addRef"/>
               <div class="clearfix"></div>
            </form>
         </div>
      </div>
      <?php
        if(!empty($errors)) {
            echo '<div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <i class="material-icons">close</i>
            </button>';
            foreach($errors as $error){
                echo '<span><b>'.$error.'</b></span>';
            }
            echo'</div>';
        }
        ?>
   </div>
</div>

<style>
form .row {
    margin: 8px 0;
}
</style>

<?php
include("includes/footer.php");
?>