<?php
include("includes/header.php");

if ($_SESSION["isAnalyticsAdmin"] == 1) {
    header("Location: analytics.php");
    exit();
}

$errors = array();

if (isset($_POST["sendNow"])) {

    $category = $_POST["category"];
    $message = $_POST["message"];
    $author = $_SESSION["user"];

    if (empty($category)) {
        array_push($errors, "Category name is required");
    }

    if (empty($message)) {
        array_push($errors, "Message is required");
    }

    if (empty($author)) {
        array_push($errors, "An error has occured");
    }

    if (empty($errors)) {

        //Send to mSpace
        $mspaceResp = "";
        if ($ENABLED_SERVICES["MSPACE"]) {
            $mspaceResp = send_message_mspace($message);
        }

        //Send to Ideamart
        $ideamartResp = "";
        if ($ENABLED_SERVICES["IDEAMART"]) {
            $ideamartResp = send_message_ideamart($message);
        }

        //Send to Ideabiz
        $ideabizResp = "";
        if ($ENABLED_SERVICES["IDEABIZ"]) {
            $ideabizResp = send_message_ideabiz($message);
        }

        $category = mysqli_real_escape_string($connect, $category);
        $message = mysqli_real_escape_string($connect, $message);
        $author = mysqli_real_escape_string($connect, $author);

        $query = mysqli_query($connect, "INSERT INTO `messages` (`id`, `message`, `category`, `author`, `hasSent`, `date`) VALUES (NULL, '$message', '$category', '$author', '1', now());");
        if ($query) {
            array_push($errors, "Successfully sent the message");
        } else {
            array_push($errors, "An error has occured");
        }
    }
}

function send_message_ideamart($message)
{
    global $IDEAMART_APP_ID, $IDEAMART_APP_PASSWORD, $IDEAMART_ENDPOINT;
    $data = array(
        'applicationId' => $IDEAMART_APP_ID,
        'password' => $IDEAMART_APP_PASSWORD,
        'destinationAddresses' => ["tel:all"],
        'message' =>   $message
    );
    return sendRequest($IDEAMART_ENDPOINT . "/sms/send", $data);
}

function send_message_mspace($message)
{
    global $MSPACE_APP_ID, $MSPACE_APP_PASSWORD, $MSPACE_ENDPOINT;
    $data = array(
        'applicationId' => $MSPACE_APP_ID,
        'password' => $MSPACE_APP_PASSWORD,
        'destinationAddresses' => ["tel:all"],
        'message' =>   $message
    );
    return sendRequest($MSPACE_ENDPOINT . "/sms/send", $data);
}

function send_message_ideabiz($message)
{
    global $IDEABIZ_APP_ID, $IDEABIZ_APP_TOKEN, $IDEABIZ_ENDPOINT,
        $IDEABIZ_SENDER_ADDR, $IDEABIZ_CLIENT_CORR, $IDEABIZ_SENDER_NAME, $IDEABIZ_SENDER_PORT,
        $connect;

    //query for ideabiz subs list
    $ideabizSubQuery = mysqli_query($connect, "SELECT subNumber FROM users WHERE platform='ideabiz' AND subscriberState='subscribed';");
    $ideaBizArray = array();
    while ($ideabizSubData = mysqli_fetch_assoc($ideabizSubQuery)) {
        array_push($ideaBizArray, $ideabizSubData['subNumber']);
    }

    $data = [
        "outboundSMSMessageRequest" => [
            "address" => $ideaBizArray,
            "senderAddress" => $IDEABIZ_SENDER_ADDR,
            "outboundSMSTextMessage" => [
                "message" => $message
            ],
            "clientCorrelator" => $IDEABIZ_CLIENT_CORR,
            "senderName" => $IDEABIZ_SENDER_NAME
        ]
    ];

    return sendRequestAuth($IDEABIZ_ENDPOINT . "/smsmessaging/v3/outbound/" . $IDEABIZ_SENDER_PORT . "/requests", $data, $IDEABIZ_APP_TOKEN);
}

if (isset($_POST["postMsg"])) {
    $category = $_POST["category"];
    $message = $_POST["message"];
    $author = $_SESSION["user"];

    if (empty($category)) {
        array_push($errors, "Category name is required");
    }

    if (empty($message)) {
        array_push($errors, "Message is required");
    }

    if (empty($author)) {
        array_push($errors, "An error has occured");
    }

    if (empty($errors)) {
        $category = mysqli_real_escape_string($connect, $category);
        $message = mysqli_real_escape_string($connect, $message);
        $author = mysqli_real_escape_string($connect, $author);
        $query = mysqli_query($connect, "INSERT INTO `messages` (`id`, `message`, `category`, `author`, `hasSent`, `date`) VALUES (NULL, '$message', '$category', '$author', '0', now());");
        if ($query) {
            array_push($errors, "Successfully added new message");
        } else {
            array_push($errors, "An error has occured");
        }
    }
}

//Send un-authenticated request
function sendRequest($endPoint, $data)
{
    $payload = json_encode($data);
    $ch = curl_init($endPoint);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    error_log($result);
    return json_decode($result, true);
}

//Send authenticated request
function sendRequestAuth($endPoint, $data, $token)
{
    $payload = json_encode($data);
    $ch = curl_init($endPoint);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type:application/json',
        'Authorization:Bearer ' . $token
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    error_log($result);
    return json_decode($result, true);
}

?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header card-header-primary">
                <h4 class="card-title">New message</h4>
                <p class="card-category">Add new message to database</p>
            </div>
            <div class="card-body">
                <form method="post" action="#">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="bmd-label-floating">Category</label>
                                <select class="form-control" name="category">
                                    <?php
                                    $catQ = mysqli_query($connect, "SELECT * FROM categories ORDER BY id ASC");
                                    while ($data = mysqli_fetch_array($catQ)) {
                                        echo '<option value="' . $data['id'] . '">' . $data['category'] . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Message</label>
                                <div class="form-group">
                                    <textarea class="form-control" rows="5" placeholder="Enter your message here" name="message"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="submit" class="btn btn-primary pull-right" value="Post Message" name="postMsg" />
                    <!-- <input type="submit" class="btn btn-primary pull-right" value="Send Now" name="sendNow" onclick="return confirm('Are you sure you want to send the message now?')" /> -->
                    <div class="clearfix"></div>
                </form>
            </div>
        </div>
        <?php
        if (!empty($errors)) {
            echo '<div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <i class="material-icons">close</i>
            </button>';
            foreach ($errors as $error) {
                echo '<span><b>' . $error . '</b></span>';
            }
            echo '</div>';
        }
        ?>
    </div>
</div>

<?php
include("includes/footer.php");
?>